package gov.va.med.mhv.sm.admin.model;

import java.util.Date;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import org.hibernate.annotations.Type;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import gov.va.med.mhv.common.data.model.AbstractBaseEntity;

@Entity
@Table(name = "ADDRESSEE")
public class Addressee extends AbstractBaseEntity{

	private static final long serialVersionUID = 710910315886430992L;
	
	@Id
	@Column(name = "ADDRESSEE_ID")
	@GeneratedValue(strategy=GenerationType.SEQUENCE, generator="sequence")
	@SequenceGenerator(name="sequence", sequenceName="GEN_SMS_SEQ")
	private Long id;
	
	@Column(name = "ACTIVE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean active;
	
	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;
	
	@Column(name = "FOLDER_ID")
	private Long folderId;

	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="SECURE_MESSAGE_ID", referencedColumnName="SECURE_MESSAGE_ID")
	private Message message;
	
	@Column(name = "SECURE_MESSAGE_ID",insertable = false, updatable = false)
	private Long messageId;
	
	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;

	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "USER_ID")
	private SMUser owner;
	
	@Column(name = "USER_ID", insertable = false, updatable = false)
	private Long userId;
	
	@Column(name = "IS_REASSIGNED", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean reAssigned;

	@Column(name = "READ_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date readDate;
	
	@Column(name = "REMINDER_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date reminderDate;
	
	@Column(name = "ADDRESSEE_ROLE")
	private Long role;

	public Addressee(){
		this.active=true;
		this.createdDate = new Date();
		this.modifiedDate = new Date();
	}
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Boolean getActive() {
		return active;
	}

	public void setActive(Boolean active) {
		this.active = active;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Long getFolderId() {
		return folderId;
	}

	public void setFolderId(Long folderId) {
		this.folderId = folderId;
	}

	public Message getMessage() {
		return message;
	}

	public void setMessage(Message message) {
		this.message = message;
	}

	public Long getMessageId() {
		return messageId;
	}

	public void setMessageId(Long messageId) {
		this.messageId = messageId;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public SMUser getOwner() {
		return owner;
	}

	public void setOwner(SMUser owner) {
		this.owner = owner;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public Boolean getReAssigned() {
		return reAssigned;
	}

	public void setReAssigned(Boolean reAssigned) {
		this.reAssigned = reAssigned;
	}

	public Date getReadDate() {
		return readDate;
	}

	public void setReadDate(Date readDate) {
		this.readDate = readDate;
	}

	public Date getReminderDate() {
		return reminderDate;
	}

	public void setReminderDate(Date reminderDate) {
		this.reminderDate = reminderDate;
	}

	public Long getRole() {
		return role;
	}

	public void setRole(Long role) {
		this.role = role;
	}
}
